package gov.va.vamf.scheduling.direct.domain;

import javax.xml.bind.annotation.*;
import java.io.Serializable;

@XmlRootElement(name = "institution", namespace = Namespace.DirectScheduling)
@XmlAccessorType(value = XmlAccessType.NONE)
@XmlType(namespace = Namespace.DirectScheduling)
public class Institution implements Serializable {

    private static final long serialVersionUID = -5380142973676038301L;

    @XmlElement
    private String institutionCode;

    @XmlElement
    private String name;

    @XmlElement
    private String city;

    @XmlElement
    private String stateAbbrev;

    @XmlElement
    private String authoritativeName;

    /**
     * The code for the top-level (aka "3-digit") station above this institution. If this institution is a 3-digit
     * station, then this will be the same as the institutionCode
     */
    @XmlElement
    private String rootStationCode;

    @XmlElement
    private Boolean adminParent;

    /**
     * For institutions that have an admin parent, this should be the code of the admin parent.
     * For institutions that are, themselves, admin parents, this should be the same as the institution's own institutionCode
     * For institutions without an admin parent, this should be the 3-digit station code.
     */
    @XmlElement
    private String parentStationCode;

    public String getInstitutionCode() {
        return institutionCode;
    }

    public void setInstitutionCode(String institutionCode) {
        this.institutionCode = institutionCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getStateAbbrev() {
        return stateAbbrev;
    }

    public void setStateAbbrev(String stateAbbrev) {
        this.stateAbbrev = stateAbbrev;
    }

    public String getAuthoritativeName() {
        return authoritativeName;
    }

    public void setAuthoritativeName(String authoritativeName) {
        this.authoritativeName = authoritativeName;
    }

    public String getRootStationCode() {
        return rootStationCode;
    }

    public void setRootStationCode(String parentFacilityCode) {
        this.rootStationCode = parentFacilityCode;
    }

    public void setAdminParent(Boolean adminParent) {
        this.adminParent = adminParent;
    }

    public Boolean isAdminParent() {
        return this.adminParent;
    }

    public String getParentStationCode() {
        return parentStationCode;
    }

    public void setParentStationCode(String parentStationCode) {
        this.parentStationCode = parentStationCode;
    }
}
